/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.ColumnConsumer;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.trace.MutableInt;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableSupplier;
import org.junit.jupiter.api.Test;

class ResultSetRowTransformerTest {
    ResultSetRowTransformerTest() {
    }

    @Test
    void transform_basicUseCase() throws SQLException {
        ResultSetRowTransformer testInstance = new ResultSetRowTransformer(Car.class, "vehicleType", DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Car((String)x$0));
        testInstance.add("wheels", DefaultResultSetReaders.INTEGER_READER, Car::setWheelCount);
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"bicycle").add((Object)"wheels", (Object)2), Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"moto").add((Object)"wheels", (Object)2), Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"car").add((Object)"wheels", (Object)4), Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"car").add((Object)"wheels", (Object)6)}));
        resultSet.next();
        Car vehicle1 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle1.getName()).isEqualTo("bicycle");
        Assertions.assertThat((int)vehicle1.getWheelCount()).isEqualTo(2);
        resultSet.next();
        Car vehicle2 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle2.getName()).isEqualTo("moto");
        Assertions.assertThat((int)vehicle2.getWheelCount()).isEqualTo(2);
        resultSet.next();
        Car vehicle3 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle3.getName()).isEqualTo("car");
        Assertions.assertThat((int)vehicle3.getWheelCount()).isEqualTo(4);
        resultSet.next();
        Car vehicle4 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle4.getName()).isEqualTo("car");
        Assertions.assertThat((Object)vehicle3).isNotSameAs((Object)vehicle4);
    }

    @Test
    void transform_noArgConstructor_basicUseCase() throws SQLException {
        ResultSetRowTransformer testInstance = new ResultSetRowTransformer(Car.class, (SerializableSupplier & Serializable)() -> new Car());
        testInstance.add("wheels", DefaultResultSetReaders.INTEGER_READER, Car::setWheelCount);
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"bicycle").add((Object)"wheels", (Object)2), Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"moto").add((Object)"wheels", (Object)2), Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"car").add((Object)"wheels", (Object)4), Maps.forHashMap(String.class, Object.class).add((Object)"vehicleType", (Object)"car").add((Object)"wheels", (Object)6)}));
        resultSet.next();
        Car vehicle1 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle1.getName()).isNull();
        Assertions.assertThat((int)vehicle1.getWheelCount()).isEqualTo(2);
        resultSet.next();
        Car vehicle2 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle2.getName()).isNull();
        Assertions.assertThat((int)vehicle2.getWheelCount()).isEqualTo(2);
        resultSet.next();
        Car vehicle3 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle3.getName()).isNull();
        Assertions.assertThat((int)vehicle3.getWheelCount()).isEqualTo(4);
        resultSet.next();
        Car vehicle4 = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)vehicle4.getName()).isNull();
        Assertions.assertThat((Object)vehicle3).isNotSameAs((Object)vehicle4);
    }

    @Test
    void transform_basicUseCase_complexConsumer() throws SQLException {
        ResultSetRowTransformer testInstance = new ResultSetRowTransformer(MutableInt.class, "a", DefaultResultSetReaders.INTEGER_READER, MutableInt::new);
        testInstance.add(new ColumnConsumer("b", DefaultResultSetReaders.INTEGER_READER, (t, i) -> t.increment(((Integer)Objects.preventNull((Object)i, (Object)0)).intValue())));
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"a", (Object)42).add((Object)"b", (Object)1), Maps.forHashMap(String.class, Object.class).add((Object)"a", (Object)666).add((Object)"b", null)}));
        resultSet.next();
        Assertions.assertThat((int)((MutableInt)testInstance.transform((ResultSet)resultSet)).getValue()).isEqualTo(43);
        resultSet.next();
        Assertions.assertThat((int)((MutableInt)testInstance.transform((ResultSet)resultSet)).getValue()).isEqualTo(666);
    }

    @Test
    void transform_shareInstanceOverRows() throws SQLException {
        MutableInt sharedInstance = new MutableInt(0);
        ResultSetRowTransformer testInstance = new ResultSetRowTransformer(MutableInt.class, "a", DefaultResultSetReaders.INTEGER_READER, (SerializableFunction & Serializable)i -> {
            sharedInstance.increment(i.intValue());
            return sharedInstance;
        });
        testInstance.add(new ColumnConsumer("b", DefaultResultSetReaders.INTEGER_READER, (t, i) -> t.increment(((Integer)Objects.preventNull((Object)i, (Object)0)).intValue())));
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"a", (Object)42).add((Object)"b", (Object)1), Maps.forHashMap(String.class, Object.class).add((Object)"a", (Object)666).add((Object)"b", null)}));
        resultSet.next();
        Assertions.assertThat((int)((MutableInt)testInstance.transform((ResultSet)resultSet)).getValue()).isEqualTo(43);
        resultSet.next();
        Assertions.assertThat((int)((MutableInt)testInstance.transform((ResultSet)resultSet)).getValue()).isEqualTo(709);
    }

    @Test
    void copyWithAliases() throws SQLException {
        ResultSetRowTransformer sourceInstance = new ResultSetRowTransformer(MutableInt.class, "a", DefaultResultSetReaders.INTEGER_READER, MutableInt::new);
        sourceInstance.add(new ColumnConsumer("b", DefaultResultSetReaders.INTEGER_READER, (t, i) -> t.increment(((Integer)Objects.preventNull((Object)i, (Object)0)).intValue())));
        ResultSetRowTransformer testInstance = sourceInstance.copyWithAliases((Map)Maps.asHashMap((Object)"a", (Object)"x").add((Object)"b", (Object)"y"));
        Assertions.assertThat((Object)testInstance).isNotSameAs((Object)sourceInstance);
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"x", (Object)42).add((Object)"y", (Object)1), Maps.forHashMap(String.class, Object.class).add((Object)"x", (Object)666).add((Object)"y", null)}));
        resultSet.next();
        Assertions.assertThat((int)((MutableInt)testInstance.transform((ResultSet)resultSet)).getValue()).isEqualTo(43);
        resultSet.next();
        Assertions.assertThat((int)((MutableInt)testInstance.transform((ResultSet)resultSet)).getValue()).isEqualTo(666);
    }

    @Test
    void copyFor() throws SQLException {
        ResultSetRowTransformer sourceInstance = new ResultSetRowTransformer(Vehicle.class, "name", DefaultResultSetReaders.STRING_READER, Vehicle::new);
        sourceInstance.add(new ColumnConsumer("color", DefaultResultSetReaders.STRING_READER, Vehicle::setColor));
        ResultSetRowTransformer testInstance = sourceInstance.copyFor(Car.class, (SerializableFunction & Serializable)x$0 -> new Car((String)x$0));
        testInstance.add(new ColumnConsumer("wheels", DefaultResultSetReaders.INTEGER_READER, Car::setWheelCount));
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"name", (Object)"peugeot").add((Object)"wheels", (Object)4).add((Object)"color", (Object)"red")}));
        resultSet.next();
        Car result = (Car)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)result.getName()).isEqualTo("peugeot");
        Assertions.assertThat((int)result.getWheelCount()).isEqualTo(4);
        Assertions.assertThat((String)result.getColor()).isEqualTo("red");
    }

    @Test
    void copyFor_withFunctionAsArg_instanceIsCreatedWithSupplier_throwsException() {
        ResultSetRowTransformer sourceInstance = new ResultSetRowTransformer(Vehicle.class, (SerializableSupplier & Serializable)() -> new Vehicle());
        sourceInstance.add(new ColumnConsumer("color", DefaultResultSetReaders.STRING_READER, Vehicle::setColor));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sourceInstance.copyFor(Car.class, (SerializableFunction & Serializable)x$0 -> new Car((String)x$0))).isInstanceOf(UnsupportedOperationException.class)).hasMessage("This instance can only be cloned with an identifier-arg constructor because it was created with one");
    }

    @Test
    void copyFor_withSupplierAsArg_instanceIsCreatedWithFunction_throwsException() {
        ResultSetRowTransformer sourceInstance = new ResultSetRowTransformer(Vehicle.class, "name", DefaultResultSetReaders.STRING_READER, Vehicle::new);
        sourceInstance.add(new ColumnConsumer("color", DefaultResultSetReaders.STRING_READER, Vehicle::setColor));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sourceInstance.copyFor(Car.class, (SerializableSupplier & Serializable)() -> new Car())).isInstanceOf(UnsupportedOperationException.class)).hasMessage("This instance can only be cloned with a no-arg constructor because it was created with one");
    }

    @Test
    void exampleWithCollection() throws SQLException {
        ResultSetRowTransformer testInstance = new ResultSetRowTransformer(Person.class, "name", DefaultResultSetReaders.STRING_READER, Person::new);
        testInstance.add("address1", DefaultResultSetReaders.STRING_READER, Person::getAddresses, Person::setAddresses, ArrayList::new);
        testInstance.add("address2", DefaultResultSetReaders.STRING_READER, Person::getAddresses, Person::setAddresses, ArrayList::new);
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, String.class).add((Object)"name", (Object)"paul").add((Object)"address1", (Object)"rue Vaugirard").add((Object)"address2", (Object)"rue Menon")}));
        resultSet.next();
        Person result = (Person)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)result.getName()).isEqualTo("paul");
        Assertions.assertThat(new HashSet<String>(result.getAddresses())).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"rue Vaugirard", "rue Menon"}));
    }

    @Test
    void relation() throws SQLException {
        ResultSetRowTransformer testInstance = new ResultSetRowTransformer(Person.class, "name", DefaultResultSetReaders.STRING_READER, Person::new);
        ResultSetRowTransformer addressTransformer = new ResultSetRowTransformer(String.class, "address1", DefaultResultSetReaders.STRING_READER, SerializableFunction.identity());
        testInstance.add(Person::addAddress, addressTransformer);
        testInstance.add(Person::addAddress, addressTransformer.copyWithAliases(s -> "address2"));
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, String.class).add((Object)"name", (Object)"paul").add((Object)"address1", (Object)"rue Vaugirard").add((Object)"address2", (Object)"rue Menon")}));
        resultSet.next();
        Person result = (Person)testInstance.transform((ResultSet)resultSet);
        Assertions.assertThat((String)result.getName()).isEqualTo("paul");
        Assertions.assertThat(new HashSet<String>(result.getAddresses())).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"rue Vaugirard", "rue Menon"}));
    }

    static class Person {
        private String name;
        private List<String> addresses = new ArrayList<String>();

        Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getAddresses() {
            return this.addresses;
        }

        public void setAddresses(List<String> addresses) {
            this.addresses = addresses;
        }

        public void addAddress(String address) {
            this.addresses.add(address);
        }
    }

    static class Car
    extends Vehicle {
        private int wheelCount;

        private Car() {
        }

        private Car(String name) {
            super(name);
        }

        public int getWheelCount() {
            return this.wheelCount;
        }

        public void setWheelCount(int wheelCount) {
            this.wheelCount = wheelCount;
        }
    }

    static class Vehicle {
        private String name;
        private String color;

        Vehicle(String name) {
            this.name = name;
        }

        private Vehicle() {
        }

        public String getName() {
            return this.name;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }
    }
}

